using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Security.Principal;
using System.Diagnostics;
using System.Data;
using System.Text;
using gov.va.med.vbecs;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{

		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/27/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>VBECS_UC_8 Blood Product Add/Edit Form User Interface</summary>

		#endregion

	public class FrmBloodProductEdit : gov.va.med.vbecs.GUI.VbecsVistALinkBaseForm
	{
		#region Variables

		/// <summary>
		/// Needed to get around the Vista Shutdown code onVistaLinkFormLoad()
		/// </summary>
		private bool _populateHcpcs = false;

		/// <summary>
		/// _bloodProduct
		/// </summary>
		private BOL.BloodProduct _bloodProduct;

		/// <summary>
		/// _productShipper
		/// </summary>
		private BOL.ProductShipper _productShipper;

		/// <summary>
		/// _facilities
		/// </summary>
		private DataTable _facilities;

		/// <summary>
		/// _hcpcsCodes
		/// </summary>
		private DataTable _hcpcsCodes;

		/// <summary>
		/// _isLoading
		/// </summary>
		private bool _isLoading = true;

		/// <summary>
		/// Division Supplier - VAMCDivision table
		/// </summary>
		private System.Guid _divisionSupplier;

		/// <summary>
		/// _onlyAllowOneEdit
		/// </summary>
		private bool _onlyAllowOneEdit = false;

		/// <summary>
		/// If another use case is requesting to acivate a supplier for a blood product, we need to know which one
		/// so the calling form can later find out if it was made active or not
		/// </summary>
		private System.Guid _targetSupplierGuid;
		private System.Windows.Forms.TextBox txtType;
		private System.Windows.Forms.TextBox txtVolume;
		private System.Windows.Forms.Label lblmL;
		private System.Windows.Forms.TextBox txtDays;
		private System.Windows.Forms.Label lblHCPCSText;
		private System.Windows.Forms.Label label2;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbFDARegNum;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbHCPCSCode;
		private System.Windows.Forms.GroupBox grpHCPCS;
		private System.Windows.Forms.TextBox txtHours;
		private System.Windows.Forms.ColumnHeader colShipper;
		private System.Windows.Forms.Label lblMaximumStorage;
		private System.Windows.Forms.Panel pnlProducts;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlHCPCSSuppliers;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbHCPCSText;

		private MultipleBloodProductCode _multipleBloodProductCode;

		#endregion

		#region Events

		/// <summary>
		/// Event for others to listen if the ProductShipper becomes actived. Nobody will probably use this.
		/// </summary>
		public event EventHandler ProductShipperActivated;

		/// <summary>
		/// Event for others to listen if the ProductShipper becomes actived. Nobody will probably use this.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		protected virtual void OnProductShipperActivated(object sender, System.EventArgs e)
		{
			if (ProductShipperActivated != null)
			{
				ProductShipperActivated(sender, e);
			}
		}

		/// <summary>
		/// BloodProductValid
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnBloodProductValid(object sender, System.EventArgs e)
		{
			string tipText;
			bool ProductShipperActive = false;
			string ProductShipperRequired = string.Empty;
			string productActiveRequired = string.Empty;

			//For the cases when we've been sent here to activate a single supplier, we need to check to make sure they've done so...
			if (this._onlyAllowOneEdit)
			{
				BOL.ProductShipper _ps = this._bloodProduct.ProductShippers.GetElementByLocalSupplierGuid(this._targetSupplierGuid);
				if (_ps != null)
				{
					ProductShipperActive = (_ps.RecordStatusCode == Common.RecordStatusCode.Active);
				}

				//Set a "broken rule message" to show the user that there's something they still need to do
				if (!ProductShipperActive)
				{
					ProductShipperRequired = Common.StrRes.Tooltips.UC008.SupplierMustBeActive().ResString;
				}

			}
		
			
			tipText = Common.Utility.SumBrokenRulesMessages(this._bloodProduct.GetBrokenRulesMessage(this.Name), this._bloodProduct.ProductType.GetBrokenRulesMessage(this.Name),ProductShipperRequired,productActiveRequired);

			btnOK.EnabledButton = this._bloodProduct.IsValid & this._bloodProduct.ProductType.IsValid & (tipText == String.Empty);

			if (tipText == String.Empty)
			{
				tipText = Common.StrRes.Tooltips.Common.OKToSave().ResString;
			}

			btnOK.SetToolTip(tipText);
		}

		/// <summary>
		/// ProductShipperValid
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnProductShipperValid(object sender, System.EventArgs e)
		{
			string tipText = String.Empty;

			if (this._productShipper != null)
			{	
				btnAdd.EnabledButton = this._productShipper.IsValid;
				tipText = this._productShipper.GetBrokenRulesMessage(this.Name);
			}

			if (tipText == String.Empty)
			{
				tipText = Common.StrRes.Tooltips.UC008.btnAdd().ResString;
			}

			btnAdd.SetToolTip(tipText);
		}

		#endregion

		#region FormControls

		private System.Windows.Forms.ColumnHeader colReturnPercent;
		private System.Windows.Forms.ColumnHeader colFDAReg;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updReturnCredit;
		private System.Windows.Forms.Label lblReturnCredit;
		private System.Windows.Forms.Label lblHcpcsCode;
		private System.Windows.Forms.Button btnHistory;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAdd;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpProduct;
		private System.Windows.Forms.Label lblCode;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Label lblHours;
		private System.Windows.Forms.Label lblDays;
		private System.Windows.Forms.Label lblType;
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.Label lblVolume;
		private System.Windows.Forms.Label lblShortName;
		private System.Windows.Forms.TextBox txtShortName;
		private System.Windows.Forms.GroupBox grpSuppliers;
		private System.Windows.Forms.ListView lvSuppliers;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updCost;
		private System.Windows.Forms.Label lblCost;
		private System.Windows.Forms.Label lblSupplier;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSupplier;
		private System.Windows.Forms.ColumnHeader colActive;
		private System.Windows.Forms.ColumnHeader colCost;
		private gov.va.med.vbecs.GUI.controls.ProductCodeTextbox txtCode;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Button btnClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnSearch;

		#endregion

		#region Constructors/Destructors


		/// <summary>
		/// FrmBloodProductEdit
		/// </summary>
		public FrmBloodProductEdit()
		{
			InitializeComponent();

			SetComponentProperties();

			this.SetBloodProductData(false);
			this.SetControlState(0);

			//The btnOK doesn't hold the design-time setting
			this.btnAdd.Text = "&Add";
			this.IsDirty=false;

			this.txtCode.Focus();
		}

		/// <summary>
		/// FrmBloodProductEdit
		/// </summary>
		/// <param name="codabar"></param>
		/// <param name="bloodProductGuid"></param>
		/// <param name="localSupplier"></param>
		public FrmBloodProductEdit(System.Guid bloodProductGuid, BOL.LocalSupplier localSupplier, bool codabar)
		{
			//This is where UC_01 24, 26 comes in...
			if (this.HasAuthorityToEditProduct())		//Not sure if we need this really -- Authority = 1 .. that's the lowest, right?? So why check?  Future changes, perhaps??
			{
				InitializeComponent();
				SetComponentProperties();

				//Save the target GUID to allow for confirmation later..since this constructor is designed to 
				//activate a product shipper for a product
				this._targetSupplierGuid = localSupplier.LocalSupplierGuid;

				this._onlyAllowOneEdit = true;
				
				if (!this.SetLocks(bloodProductGuid))
				{
					this.DialogResult = DialogResult.Abort;
					return;
				}

				this._bloodProduct = new BOL.BloodProduct(bloodProductGuid);

				//If the blood product hasn't been activated AT ALL yet, then we'll need to make the user do that RIGHT AWAY!
				if (this._bloodProduct.HcpcsCode.Trim() == string.Empty)
                    this._bloodProduct.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmBloodProductEdit.RuleSets.FirstEdit);
				else
					this._bloodProduct.SetInitialBrokenRules(this.Name);

				this.AttachBloodProductEvents();

				//In case it's inactive -- still use the common method
				if (this.GetProductShipper(localSupplier.LocalSupplierGuid))
				{
					//Search through the combobox for the local supplier we're trying to attach to this bloodproduct
					for (int ndx=0; ndx < this.cmbSupplier.Items.Count ; ndx++)
					{
						if (this.cmbSupplier.Items[ndx].ToString() == localSupplier.FacilityName)
						{
							this.cmbSupplier.SelectedIndex = ndx;
							this._productShipper.LocalSupplierGuid = localSupplier.LocalSupplierGuid;
							break;
						}
					}

					//If the entry doesn't = LocalEntry, then it's inactive or never was
					if (localSupplier.RecordStatusCode != Common.RecordStatusCode.LocalEntry)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC008.SupplierError(localSupplier.FacilityName));
						
						FrmCollectionFacilityMaintain frmCollectionFacility = new FrmCollectionFacilityMaintain(localSupplier.FDARegistrationNumber);
                        //LOCKING420 - refactored to use new locking friendly method
                        frmCollectionFacility.ShowDialogFromLockedParent(this, true);
						DialogResult dr = frmCollectionFacility.DialogResult;
						frmCollectionFacility.Dispose();

						if (dr == DialogResult.Abort || dr == DialogResult.Cancel) 
						{
							this.DialogResult = DialogResult.Abort;
							return;
						}

						this.LoadFDAComboBox();

						for (int ndx=0; ndx < this.cmbSupplier.Items.Count ; ndx++)
						{
							if (this.cmbSupplier.Items[ndx].ToString() == localSupplier.FacilityName)
							{
								this.cmbSupplier.SelectedIndex = ndx;
								this._productShipper.LocalSupplierGuid = localSupplier.LocalSupplierGuid;
								break;
							}
						}
					}
				}

				this.SetBloodProductData(true);
				this.SetControlState(2);

				this.btnSearch.Enabled = false;
				this.btnClear.Enabled = false;


				this.vbecsLogo1.Title = string.Concat("Activate ",this._bloodProduct.ProductShortName," for ",localSupplier.FacilityName);

				//We have to set the values because of the BR (unwritten).  You can set ProuctCost to 0 for your division.
				this._productShipper.ProductCost = this.updCost.Value;
				this._productShipper.ReturnCreditPercentage = this.updReturnCredit.Value;

				//Force the brokenrule stuff to activate the OK button correctly
				this.OnBloodProductValid(this, System.EventArgs.Empty);
				this.OnProductShipperValid(this, System.EventArgs.Empty);
				this.IsDirty=false;
			}
			else
			{
				this.InvalidUserAuthority();
				this.DialogResult = DialogResult.Abort;
			}
		}

		/// <summary>
		/// Cleans up any resources being used
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmBloodProductEdit));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpProduct = new System.Windows.Forms.GroupBox();
			this.txtHours = new System.Windows.Forms.TextBox();
			this.txtDays = new System.Windows.Forms.TextBox();
			this.lblmL = new System.Windows.Forms.Label();
			this.txtVolume = new System.Windows.Forms.TextBox();
			this.txtType = new System.Windows.Forms.TextBox();
			this.lblMaximumStorage = new System.Windows.Forms.Label();
			this.btnClear = new System.Windows.Forms.Button();
			this.txtCode = new gov.va.med.vbecs.GUI.controls.ProductCodeTextbox(this.components);
			this.btnSearch = new System.Windows.Forms.Button();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.lblCode = new System.Windows.Forms.Label();
			this.txtShortName = new System.Windows.Forms.TextBox();
			this.lblType = new System.Windows.Forms.Label();
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblVolume = new System.Windows.Forms.Label();
			this.lblName = new System.Windows.Forms.Label();
			this.lblShortName = new System.Windows.Forms.Label();
			this.lblDays = new System.Windows.Forms.Label();
			this.lblHours = new System.Windows.Forms.Label();
			this.btnHistory = new System.Windows.Forms.Button();
			this.lblHcpcsCode = new System.Windows.Forms.Label();
			this.grpSuppliers = new System.Windows.Forms.GroupBox();
			this.cmbFDARegNum = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.label2 = new System.Windows.Forms.Label();
			this.btnAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.updReturnCredit = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblReturnCredit = new System.Windows.Forms.Label();
			this.cmbSupplier = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lvSuppliers = new System.Windows.Forms.ListView();
			this.colActive = new System.Windows.Forms.ColumnHeader();
			this.colFDAReg = new System.Windows.Forms.ColumnHeader();
			this.colShipper = new System.Windows.Forms.ColumnHeader();
			this.colCost = new System.Windows.Forms.ColumnHeader();
			this.colReturnPercent = new System.Windows.Forms.ColumnHeader();
			this.updCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblCost = new System.Windows.Forms.Label();
			this.lblSupplier = new System.Windows.Forms.Label();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.cmbHCPCSCode = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpHCPCS = new System.Windows.Forms.GroupBox();
			this.cmbHCPCSText = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblHCPCSText = new System.Windows.Forms.Label();
			this.pnlProducts = new System.Windows.Forms.Panel();
			this.pnlHCPCSSuppliers = new System.Windows.Forms.Panel();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.grpImage.SuspendLayout();
			this.grpProduct.SuspendLayout();
			this.grpSuppliers.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updReturnCredit)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updCost)).BeginInit();
			this.grpHCPCS.SuspendLayout();
			this.pnlProducts.SuspendLayout();
			this.pnlHCPCSSuppliers.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
			this.vbecsLogo1.TabIndex = 3;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 361);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 316);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 3;
			this.pictureBox1.TabStop = false;
			// 
			// grpProduct
			// 
			this.grpProduct.AccessibleDescription = "Blood Product";
			this.grpProduct.AccessibleName = "Blood Product";
			this.grpProduct.Controls.Add(this.txtHours);
			this.grpProduct.Controls.Add(this.txtDays);
			this.grpProduct.Controls.Add(this.lblmL);
			this.grpProduct.Controls.Add(this.txtVolume);
			this.grpProduct.Controls.Add(this.txtType);
			this.grpProduct.Controls.Add(this.lblMaximumStorage);
			this.grpProduct.Controls.Add(this.btnClear);
			this.grpProduct.Controls.Add(this.txtCode);
			this.grpProduct.Controls.Add(this.btnSearch);
			this.grpProduct.Controls.Add(this.pictureBox2);
			this.grpProduct.Controls.Add(this.lblCode);
			this.grpProduct.Controls.Add(this.txtShortName);
			this.grpProduct.Controls.Add(this.lblType);
			this.grpProduct.Controls.Add(this.txtName);
			this.grpProduct.Controls.Add(this.lblVolume);
			this.grpProduct.Controls.Add(this.lblName);
			this.grpProduct.Controls.Add(this.lblShortName);
			this.grpProduct.Controls.Add(this.lblDays);
			this.grpProduct.Controls.Add(this.lblHours);
			this.grpProduct.Dock = System.Windows.Forms.DockStyle.Left;
			this.grpProduct.Location = new System.Drawing.Point(0, 0);
			this.grpProduct.Name = "grpProduct";
			this.grpProduct.Size = new System.Drawing.Size(314, 316);
			this.grpProduct.TabIndex = 0;
			this.grpProduct.TabStop = false;
			this.grpProduct.Text = "Blood Product";
			// 
			// txtHours
			// 
			this.txtHours.AccessibleDescription = "Maximum Storage Hours";
			this.txtHours.AccessibleName = "Maximum Storage Hours";
			this.txtHours.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.txtHours.Location = new System.Drawing.Point(216, 284);
			this.txtHours.Name = "txtHours";
			this.txtHours.ReadOnly = true;
			this.txtHours.Size = new System.Drawing.Size(48, 20);
			this.txtHours.TabIndex = 10;
			this.txtHours.Text = "";
			// 
			// txtDays
			// 
			this.txtDays.AccessibleDescription = "Maximum Storage Days";
			this.txtDays.AccessibleName = "Maximum Storage Days";
			this.txtDays.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.txtDays.Location = new System.Drawing.Point(136, 284);
			this.txtDays.Name = "txtDays";
			this.txtDays.ReadOnly = true;
			this.txtDays.Size = new System.Drawing.Size(48, 20);
			this.txtDays.TabIndex = 9;
			this.txtDays.Text = "";
			// 
			// lblmL
			// 
			this.lblmL.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblmL.Location = new System.Drawing.Point(184, 260);
			this.lblmL.Name = "lblmL";
			this.lblmL.Size = new System.Drawing.Size(40, 20);
			this.lblmL.TabIndex = 11;
			this.lblmL.Text = "mL";
			this.lblmL.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtVolume
			// 
			this.txtVolume.AccessibleDescription = "Volume milliliters";
			this.txtVolume.AccessibleName = "Volume milliliters";
			this.txtVolume.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.txtVolume.Location = new System.Drawing.Point(136, 260);
			this.txtVolume.Name = "txtVolume";
			this.txtVolume.ReadOnly = true;
			this.txtVolume.Size = new System.Drawing.Size(48, 20);
			this.txtVolume.TabIndex = 8;
			this.txtVolume.Text = "";
			// 
			// txtType
			// 
			this.txtType.AccessibleDescription = "Product Type";
			this.txtType.AccessibleName = "Product Type";
			this.txtType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtType.Location = new System.Drawing.Point(136, 204);
			this.txtType.Multiline = true;
			this.txtType.Name = "txtType";
			this.txtType.ReadOnly = true;
			this.txtType.Size = new System.Drawing.Size(166, 48);
			this.txtType.TabIndex = 7;
			this.txtType.Text = "";
			// 
			// lblMaximumStorage
			// 
			this.lblMaximumStorage.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblMaximumStorage.Location = new System.Drawing.Point(24, 284);
			this.lblMaximumStorage.Name = "lblMaximumStorage";
			this.lblMaximumStorage.Size = new System.Drawing.Size(128, 20);
			this.lblMaximumStorage.TabIndex = 12;
			this.lblMaximumStorage.Text = "Maximum Storage";
			this.lblMaximumStorage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(226, 16);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 2;
			this.btnClear.Text = "&Clear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// txtCode
			// 
			this.txtCode.AccessibleDescription = "Product Code";
			this.txtCode.AccessibleName = "Product Code";
			this.txtCode.Barcode = false;
			this.txtCode.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtCode.Location = new System.Drawing.Point(136, 16);
			this.txtCode.MaxLength = 10;
			this.txtCode.Name = "txtCode";
			this.txtCode.RecursionGuard = false;
			this.txtCode.Size = new System.Drawing.Size(56, 20);
			this.txtCode.TabIndex = 0;
			this.txtCode.Text = "";
			this.txtCode.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtCode_KeyUp);
			this.txtCode.Leave += new System.EventHandler(this.txtCode_Leave);
			// 
			// btnSearch
			// 
			this.btnSearch.AccessibleDescription = "Find";
			this.btnSearch.AccessibleName = "Find";
			this.btnSearch.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Location = new System.Drawing.Point(192, 16);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(24, 20);
			this.btnSearch.TabIndex = 1;
			this.btnSearch.Text = "find";
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 22);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(20, 20);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 22;
			this.pictureBox2.TabStop = false;
			// 
			// lblCode
			// 
			this.lblCode.Location = new System.Drawing.Point(24, 16);
			this.lblCode.Name = "lblCode";
			this.lblCode.Size = new System.Drawing.Size(92, 20);
			this.lblCode.TabIndex = 0;
			this.lblCode.Text = "Product Code*";
			this.lblCode.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtShortName
			// 
			this.txtShortName.AccessibleDescription = "Short Product Name";
			this.txtShortName.AccessibleName = "Short Product Name";
			this.txtShortName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtShortName.Location = new System.Drawing.Point(136, 40);
			this.txtShortName.MaxLength = 40;
			this.txtShortName.Name = "txtShortName";
			this.txtShortName.ReadOnly = true;
			this.txtShortName.Size = new System.Drawing.Size(166, 20);
			this.txtShortName.TabIndex = 4;
			this.txtShortName.Text = "";
			// 
			// lblType
			// 
			this.lblType.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblType.Location = new System.Drawing.Point(24, 204);
			this.lblType.Name = "lblType";
			this.lblType.Size = new System.Drawing.Size(100, 20);
			this.lblType.TabIndex = 7;
			this.lblType.Text = "Product Type";
			this.lblType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtName
			// 
			this.txtName.AccessibleDescription = "Full Product Name";
			this.txtName.AccessibleName = "Full Product Name";
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Location = new System.Drawing.Point(136, 64);
			this.txtName.MaxLength = 175;
			this.txtName.Multiline = true;
			this.txtName.Name = "txtName";
			this.txtName.ReadOnly = true;
			this.txtName.Size = new System.Drawing.Size(166, 132);
			this.txtName.TabIndex = 6;
			this.txtName.Text = "";
			// 
			// lblVolume
			// 
			this.lblVolume.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblVolume.Location = new System.Drawing.Point(24, 260);
			this.lblVolume.Name = "lblVolume";
			this.lblVolume.Size = new System.Drawing.Size(96, 20);
			this.lblVolume.TabIndex = 9;
			this.lblVolume.Text = "Volume";
			this.lblVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(24, 64);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(108, 20);
			this.lblName.TabIndex = 5;
			this.lblName.Text = "Full Product Name";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblShortName
			// 
			this.lblShortName.Location = new System.Drawing.Point(24, 40);
			this.lblShortName.Name = "lblShortName";
			this.lblShortName.Size = new System.Drawing.Size(116, 20);
			this.lblShortName.TabIndex = 3;
			this.lblShortName.Text = "Short Product Name";
			this.lblShortName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblDays
			// 
			this.lblDays.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblDays.Location = new System.Drawing.Point(184, 284);
			this.lblDays.Name = "lblDays";
			this.lblDays.Size = new System.Drawing.Size(32, 20);
			this.lblDays.TabIndex = 14;
			this.lblDays.Text = "Days";
			this.lblDays.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblHours
			// 
			this.lblHours.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblHours.Location = new System.Drawing.Point(264, 284);
			this.lblHours.Name = "lblHours";
			this.lblHours.Size = new System.Drawing.Size(40, 20);
			this.lblHours.TabIndex = 16;
			this.lblHours.Text = "Hours";
			this.lblHours.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnHistory
			// 
			this.btnHistory.AccessibleDescription = "History";
			this.btnHistory.AccessibleName = "History";
			this.btnHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnHistory.Image = ((System.Drawing.Image)(resources.GetObject("btnHistory.Image")));
			this.btnHistory.ImageAlign = System.Drawing.ContentAlignment.BottomRight;
			this.btnHistory.Location = new System.Drawing.Point(276, 16);
			this.btnHistory.Name = "btnHistory";
			this.btnHistory.Size = new System.Drawing.Size(24, 22);
			this.btnHistory.TabIndex = 13;
			this.btnHistory.Click += new System.EventHandler(this.btnHistory_Click);
			// 
			// lblHcpcsCode
			// 
			this.lblHcpcsCode.Location = new System.Drawing.Point(8, 16);
			this.lblHcpcsCode.Name = "lblHcpcsCode";
			this.lblHcpcsCode.Size = new System.Drawing.Size(96, 20);
			this.lblHcpcsCode.TabIndex = 0;
			this.lblHcpcsCode.Text = "HCPCS Code*";
			this.lblHcpcsCode.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSuppliers
			// 
			this.grpSuppliers.AccessibleDescription = "Product Shippers";
			this.grpSuppliers.AccessibleName = "Product Shippers";
			this.grpSuppliers.Controls.Add(this.cmbFDARegNum);
			this.grpSuppliers.Controls.Add(this.label2);
			this.grpSuppliers.Controls.Add(this.btnAdd);
			this.grpSuppliers.Controls.Add(this.updReturnCredit);
			this.grpSuppliers.Controls.Add(this.lblReturnCredit);
			this.grpSuppliers.Controls.Add(this.cmbSupplier);
			this.grpSuppliers.Controls.Add(this.lvSuppliers);
			this.grpSuppliers.Controls.Add(this.updCost);
			this.grpSuppliers.Controls.Add(this.lblCost);
			this.grpSuppliers.Controls.Add(this.lblSupplier);
			this.grpSuppliers.Dock = System.Windows.Forms.DockStyle.Fill;
			this.grpSuppliers.Location = new System.Drawing.Point(0, 68);
			this.grpSuppliers.Name = "grpSuppliers";
			this.grpSuppliers.Size = new System.Drawing.Size(308, 248);
			this.grpSuppliers.TabIndex = 15;
			this.grpSuppliers.TabStop = false;
			this.grpSuppliers.Text = "Product Shippers";
			// 
			// cmbFDARegNum
			// 
			this.cmbFDARegNum.AccessibleDescription = "F D A Registration Number";
			this.cmbFDARegNum.AccessibleName = "F D A Registration Number";
			this.cmbFDARegNum.Interval = 500;
			this.cmbFDARegNum.Location = new System.Drawing.Point(96, 40);
			this.cmbFDARegNum.Name = "cmbFDARegNum";
			this.cmbFDARegNum.Size = new System.Drawing.Size(120, 22);
			this.cmbFDARegNum.TabIndex = 17;
			this.cmbFDARegNum.SelectedIndexChanged += new System.EventHandler(this.cmbFDARegNum_SelectedIndexChanged);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 40);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(112, 20);
			this.label2.TabIndex = 2;
			this.label2.Text = "FDA Reg. #*";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnAdd
			// 
			this.btnAdd.AccessibleDescription = "Add";
			this.btnAdd.AccessibleName = "Add";
			this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAdd.EnabledButton = false;
			this.btnAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
			this.btnAdd.Location = new System.Drawing.Point(224, 84);
			this.btnAdd.Name = "btnAdd";
			this.btnAdd.Size = new System.Drawing.Size(75, 23);
			this.btnAdd.TabIndex = 20;
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			// 
			// updReturnCredit
			// 
			this.updReturnCredit.AccessibleDescription = "Return Credit";
			this.updReturnCredit.AccessibleName = "Return Credit";
			this.updReturnCredit.Location = new System.Drawing.Point(96, 88);
			this.updReturnCredit.Name = "updReturnCredit";
			this.updReturnCredit.Size = new System.Drawing.Size(48, 20);
			this.updReturnCredit.TabIndex = 19;
			this.updReturnCredit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updReturnCredit.Value = new System.Decimal(new int[] {
																		  100,
																		  0,
																		  0,
																		  0});
			this.updReturnCredit.TextChanged += new System.EventHandler(this.ReturnCreditChangedEvent);
			this.updReturnCredit.Leave += new System.EventHandler(this.ReturnCreditLeaveEvent);
			this.updReturnCredit.ValueChanged += new System.EventHandler(this.ReturnCreditChangedEvent);
			// 
			// lblReturnCredit
			// 
			this.lblReturnCredit.Location = new System.Drawing.Point(8, 88);
			this.lblReturnCredit.Name = "lblReturnCredit";
			this.lblReturnCredit.Size = new System.Drawing.Size(92, 20);
			this.lblReturnCredit.TabIndex = 6;
			this.lblReturnCredit.Text = "Return Credit %*";
			this.lblReturnCredit.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbSupplier
			// 
			this.cmbSupplier.AccessibleDescription = "Shipper Name";
			this.cmbSupplier.AccessibleName = "Shipper Name";
			this.cmbSupplier.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbSupplier.DropDownWidth = 300;
			this.cmbSupplier.Interval = 500;
			this.cmbSupplier.Location = new System.Drawing.Point(96, 16);
			this.cmbSupplier.Name = "cmbSupplier";
			this.cmbSupplier.Size = new System.Drawing.Size(204, 22);
			this.cmbSupplier.TabIndex = 16;
			this.cmbSupplier.SelectedIndexChanged += new System.EventHandler(this.cmbSupplier_SelectedIndexChanged);
			// 
			// lvSuppliers
			// 
			this.lvSuppliers.AccessibleDescription = "Product Shippers";
			this.lvSuppliers.AccessibleName = "Product Shippers";
			this.lvSuppliers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSuppliers.CheckBoxes = true;
			this.lvSuppliers.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.colActive,
																						  this.colFDAReg,
																						  this.colShipper,
																						  this.colCost,
																						  this.colReturnPercent});
			this.lvSuppliers.FullRowSelect = true;
			this.lvSuppliers.HideSelection = false;
			this.lvSuppliers.Location = new System.Drawing.Point(8, 112);
			this.lvSuppliers.MultiSelect = false;
			this.lvSuppliers.Name = "lvSuppliers";
			this.lvSuppliers.Size = new System.Drawing.Size(290, 128);
			this.lvSuppliers.TabIndex = 21;
			this.lvSuppliers.View = System.Windows.Forms.View.Details;
			this.lvSuppliers.Click += new System.EventHandler(this.lvSuppliers_Click);
			this.lvSuppliers.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSuppliers_ColumnClick);
			this.lvSuppliers.SelectedIndexChanged += new System.EventHandler(this.lvSuppliers_SelectedIndexChanged);
			this.lvSuppliers.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSuppliers_ItemCheck);
			// 
			// colActive
			// 
			this.colActive.Text = "Active";
			this.colActive.Width = 43;
			// 
			// colFDAReg
			// 
			this.colFDAReg.Text = "FDA Reg #";
			this.colFDAReg.Width = 70;
			// 
			// colShipper
			// 
			this.colShipper.Text = "Shipper";
			this.colShipper.Width = 90;
			// 
			// colCost
			// 
			this.colCost.Text = "Cost";
			this.colCost.Width = 50;
			// 
			// colReturnPercent
			// 
			this.colReturnPercent.Text = "Return %";
			// 
			// updCost
			// 
			this.updCost.AccessibleDescription = "Cost";
			this.updCost.AccessibleName = "Cost";
			this.updCost.DecimalPlaces = 2;
			this.updCost.Location = new System.Drawing.Point(96, 64);
			this.updCost.Maximum = new System.Decimal(new int[] {
																	999999,
																	0,
																	0,
																	131072});
			this.updCost.Name = "updCost";
			this.updCost.Size = new System.Drawing.Size(72, 20);
			this.updCost.TabIndex = 18;
			this.updCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updCost.Value = new System.Decimal(new int[] {
																  0,
																  0,
																  0,
																  0});
			this.updCost.TextChanged += new System.EventHandler(this.CostChangedEvent);
			this.updCost.Leave += new System.EventHandler(this.CostLeaveEvent);
			this.updCost.ValueChanged += new System.EventHandler(this.CostChangedEvent);
			// 
			// lblCost
			// 
			this.lblCost.Location = new System.Drawing.Point(8, 64);
			this.lblCost.Name = "lblCost";
			this.lblCost.Size = new System.Drawing.Size(96, 20);
			this.lblCost.TabIndex = 4;
			this.lblCost.Text = "Cost ($)*";
			this.lblCost.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSupplier
			// 
			this.lblSupplier.Location = new System.Drawing.Point(8, 16);
			this.lblSupplier.Name = "lblSupplier";
			this.lblSupplier.Size = new System.Drawing.Size(96, 20);
			this.lblSupplier.TabIndex = 0;
			this.lblSupplier.Text = "Shipper Name*";
			this.lblSupplier.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(614, 352);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 23;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// cmbHCPCSCode
			// 
			this.cmbHCPCSCode.AccessibleDescription = "Hick Picks Code";
			this.cmbHCPCSCode.AccessibleName = "Hick Picks Code";
			this.cmbHCPCSCode.Interval = 500;
			this.cmbHCPCSCode.Location = new System.Drawing.Point(96, 16);
			this.cmbHCPCSCode.Name = "cmbHCPCSCode";
			this.cmbHCPCSCode.Size = new System.Drawing.Size(120, 22);
			this.cmbHCPCSCode.TabIndex = 12;
			this.cmbHCPCSCode.SelectedIndexChanged += new System.EventHandler(this.cmbHcpcs_SelectedIndexChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(534, 352);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 22;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpHCPCS
			// 
			this.grpHCPCS.AccessibleDescription = "Hick Picks";
			this.grpHCPCS.AccessibleName = "Hick Picks";
			this.grpHCPCS.Controls.Add(this.cmbHCPCSCode);
			this.grpHCPCS.Controls.Add(this.cmbHCPCSText);
			this.grpHCPCS.Controls.Add(this.lblHCPCSText);
			this.grpHCPCS.Controls.Add(this.lblHcpcsCode);
			this.grpHCPCS.Controls.Add(this.btnHistory);
			this.grpHCPCS.Dock = System.Windows.Forms.DockStyle.Top;
			this.grpHCPCS.Location = new System.Drawing.Point(0, 0);
			this.grpHCPCS.Name = "grpHCPCS";
			this.grpHCPCS.Size = new System.Drawing.Size(308, 68);
			this.grpHCPCS.TabIndex = 11;
			this.grpHCPCS.TabStop = false;
			this.grpHCPCS.Text = "HCPCS";
			// 
			// cmbHCPCSText
			// 
			this.cmbHCPCSText.AccessibleDescription = "Hick Picks Text";
			this.cmbHCPCSText.AccessibleName = "Hick Picks Text";
			this.cmbHCPCSText.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbHCPCSText.DropDownWidth = 204;
			this.cmbHCPCSText.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cmbHCPCSText.Interval = 500;
			this.cmbHCPCSText.ItemHeight = 14;
			this.cmbHCPCSText.Location = new System.Drawing.Point(96, 40);
			this.cmbHCPCSText.Name = "cmbHCPCSText";
			this.cmbHCPCSText.Size = new System.Drawing.Size(204, 22);
			this.cmbHCPCSText.TabIndex = 14;
			this.cmbHCPCSText.SelectedIndexChanged += new System.EventHandler(this.cmbHCPCSText_SelectedIndexChanged);
			// 
			// lblHCPCSText
			// 
			this.lblHCPCSText.Location = new System.Drawing.Point(8, 40);
			this.lblHCPCSText.Name = "lblHCPCSText";
			this.lblHCPCSText.Size = new System.Drawing.Size(96, 20);
			this.lblHCPCSText.TabIndex = 2;
			this.lblHCPCSText.Text = "HCPCS Text*";
			this.lblHCPCSText.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlProducts
			// 
			this.pnlProducts.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlProducts.Controls.Add(this.pnlHCPCSSuppliers);
			this.pnlProducts.Controls.Add(this.splitter1);
			this.pnlProducts.Controls.Add(this.grpProduct);
			this.pnlProducts.Location = new System.Drawing.Point(60, 32);
			this.pnlProducts.Name = "pnlProducts";
			this.pnlProducts.Size = new System.Drawing.Size(630, 316);
			this.pnlProducts.TabIndex = 0;
			// 
			// pnlHCPCSSuppliers
			// 
			this.pnlHCPCSSuppliers.Controls.Add(this.grpSuppliers);
			this.pnlHCPCSSuppliers.Controls.Add(this.grpHCPCS);
			this.pnlHCPCSSuppliers.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlHCPCSSuppliers.Location = new System.Drawing.Point(322, 0);
			this.pnlHCPCSSuppliers.Name = "pnlHCPCSSuppliers";
			this.pnlHCPCSSuppliers.Size = new System.Drawing.Size(308, 316);
			this.pnlHCPCSSuppliers.TabIndex = 2;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(314, 0);
			this.splitter1.MinExtra = 308;
			this.splitter1.MinSize = 308;
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(8, 316);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// FrmBloodProductEdit
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(692, 377);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.pnlProducts);
			this.hlphelpChm.SetHelpKeyword(this, "Blood_Products.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(700, 350);
			this.Name = "FrmBloodProductEdit";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Maintain Blood Products";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmBloodProductEdit_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlProducts, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpProduct.ResumeLayout(false);
			this.grpSuppliers.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updReturnCredit)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updCost)).EndInit();
			this.grpHCPCS.ResumeLayout(false);
			this.pnlProducts.ResumeLayout(false);
			this.pnlHCPCSSuppliers.ResumeLayout(false);
			this.ResumeLayout(false);

		}

		#endregion

		#region Methods

		/// <summary>
		/// VistALinkFormLoad Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnVistALinkFormLoad( EventArgs e )
		{
			//Load the hcpcs combo boxes
			this.LoadHcpcsComboBox();

			if (this._populateHcpcs)
			{
				this.SetCmbHcpcsIndex(this._bloodProduct.HcpcsCode);
			}
		}

		/// <summary>
		/// Resets all the error providors 
		/// </summary>
		private void ClearErrorProvider()
		{
			this.errError.SetVbecsError(this.cmbHCPCSCode, string.Empty);
			this.errError.SetVbecsError(this.cmbSupplier, string.Empty);
			this.errError.SetVbecsError(this.txtCode, string.Empty);
			this.errError.SetVbecsError(this.updCost, String.Empty);
			this.errError.SetVbecsError(this.updReturnCredit, String.Empty);
		}


		/// <summary>
		/// Creates the concatination of Facilty and FDAReg#.
		/// </summary>
		/// <param name="facilityName"></param>
		/// <param name="fdaRegistrationNumber"></param>
		/// <returns></returns>
		private string GetSupplierNameForComboBox(string facilityName, string fdaRegistrationNumber)
		{
			return facilityName + " (" + fdaRegistrationNumber + ")";
		}


		/// <summary>
		/// Creates a new instance of ProductShipper for _productShipper object
		/// </summary>
		private bool GetProductShipper(System.Guid localsupplierGuid)
		{
			bool nameChanged = false;
			bool supplierExists = false;
			System.Guid ProductShipperGuid = System.Guid.NewGuid();

			if (localsupplierGuid != System.Guid.Empty)
			{
				supplierExists = this._bloodProduct.ProductShippers.DoesLocalSupplierExist(localsupplierGuid);
				
				//This means we changed the name -- or we came in from the Constructor
				if (!supplierExists)
				{
					nameChanged = (!this._onlyAllowOneEdit);
				}
				this._productShipper = null;
			}
			else
			{
				if (this.cmbSupplier.SelectedIndex != -1)
				{
					localsupplierGuid = (System.Guid)this._facilities.Rows[this.cmbSupplier.SelectedIndex][Common.VbecsTables.LocalSupplier.LocalSupplierGuid];
					supplierExists = this._bloodProduct.ProductShippers.DoesLocalSupplierExist(localsupplierGuid);
				}
			}

			if (supplierExists)
			{
				ProductShipperGuid = this._bloodProduct.ProductShippers.GetElementByLocalSupplierGuid(localsupplierGuid).ProductShipperGuid;
			}

			if (this._productShipper == null)
			{
				this._productShipper = new BOL.ProductShipper(ProductShipperGuid, this._bloodProduct.BloodProductGuid);
				this._productShipper.LocalSupplierGuid = localsupplierGuid;
				this._productShipper.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmBloodProductEdit.RuleSets.NewProductSupplier);
				this.AttachProductShipperEvents();

				if (supplierExists)
				{
					BOL.ProductShipper tmp = this._bloodProduct.ProductShippers.GetElementByLocalSupplierGuid(localsupplierGuid);
					
					this._productShipper.LocalSupplierGuid = tmp.LocalSupplierGuid;
					this._productShipper.ProductCost = tmp.ProductCost;
					this._productShipper.ReturnCreditPercentage = tmp.ReturnCreditPercentage;
					
					if (!tmp.IsNew)
					{
						this._productShipper.RowVersion = tmp.RowVersion;
					

					}
				}
			}

			//Since they did a name change, we want to automatically load up what values they have entered
			if (nameChanged) this.SetCostValues();	//2 lines moved to SetCostValues() method for code reuse - CR3024

			btnAdd.Text = (supplierExists) ? "&Update" : "&Add";

			return(true);
        }


		/// <summary>
		/// Sets the object cost values - CR 3024
		/// </summary>
		private void SetCostValues()
		{
			if (this._isLoading) return;
			if (this._productShipper == null) return;
			
			this._productShipper.ProductCost = this.updCost.Value;
			this._productShipper.ReturnCreditPercentage = this.updReturnCredit.Value;
		}

		/// <summary>
		/// Sets the control state.
		/// 0 = disable everything
		/// 1 = enable everything (add)- obsolete
		/// 2 = edit mode
		/// </summary>
		/// <param name="_formState"></param>
		private void SetControlState(int _formState)
		{
			this._isLoading = true;

			switch (_formState)
			{
					//This is basically disable everything (initial load)
				case (0):
					this.txtCode.Enabled = true;
					this.grpHCPCS.Enabled = false;
					this.cmbFDARegNum.Enabled = false;
					this.cmbSupplier.Enabled = false;
					this.grpSuppliers.Enabled = false;
					this.txtCode.Focus();
					this.btnOK.EnabledButton = false;
					break;

					//This is for after a product is selected (edit)
				case (2):
					this.txtCode.Enabled = false;
					this.grpHCPCS.Enabled = true;
					this.grpSuppliers.Enabled = true;
					this.cmbSupplier.Enabled = (!this._onlyAllowOneEdit);
					this.cmbFDARegNum.Enabled = (!this._onlyAllowOneEdit);
					this.cmbHCPCSCode.Focus();
					this.btnOK.EnabledButton = false;
					break;
			}
			this.btnAdd.EnabledButton = false;

			this._isLoading = false;
		}					


		/// <summary>
		/// SetCmbHcpcsIndex
		/// </summary>
		/// <param name="hcpcsCode"></param>
		private void SetCmbHcpcsIndex(string hcpcsCode)
		{
			//temp fix, there are some entries on file without the P!!!
			if (!hcpcsCode.StartsWith("P"))
			{
				hcpcsCode = "P" + hcpcsCode;
			}
			this.cmbHCPCSCode.SelectedIndex = this.cmbHCPCSCode.Items.IndexOf(hcpcsCode.Trim());
			this.cmbHCPCSText.SelectedIndex = this.cmbHCPCSCode.SelectedIndex;
		}


		/// <summary>
		/// SetBloodProductData
		/// </summary>
		/// <param name="useObject"></param>
		private void SetBloodProductData(bool useObject)
		{
			this._isLoading = true;

			if (useObject)
			{
				this._populateHcpcs = true;

				this.txtCode.Text = this._bloodProduct.ProductCode;
				this.txtShortName.Text = this._bloodProduct.ProductShortName;
				this.txtName.Text = this._bloodProduct.ProductName;
				this.txtType.Text = this._bloodProduct.ProductType.ProductTypeText;
				this.txtVolume.Text = this._bloodProduct.ProductVolume.ToString();
				this.txtDays.Text = this._bloodProduct.MaximumStorageDays.ToString();
				this.txtHours.Text = this._bloodProduct.MaximumStorageHours.ToString();
				this.SetCmbHcpcsIndex(this._bloodProduct.HcpcsCode);
			}
			else
			{
				this.txtCode.Text = String.Empty;
				this.txtShortName.Text = String.Empty;
				this.txtName.Text = String.Empty;
				this.txtType.Text = String.Empty;
				this.txtVolume.Text = String.Empty;
				this.txtDays.Text = String.Empty;
				this.txtHours.Text = String.Empty;
				this.cmbHCPCSCode.SelectedIndex = -1;
				this.cmbHCPCSText.SelectedIndex = -1;
			}			

			this.LoadSuppliers();
			this.SetSupplierData(this._onlyAllowOneEdit);

			this._isLoading = false;
		}


		/// <summary>
		/// InvalidUserAuthority
		/// </summary>
		private void InvalidUserAuthority()
		{
			GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges(
				"edit blood product information"));
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}


		/// <summary>
		/// AttachBloodProductEvents
		/// </summary>
		private void AttachBloodProductEvents()
		{
			this._bloodProduct.Valid += new System.EventHandler(OnBloodProductValid);
			this._bloodProduct.Invalid += new System.EventHandler(OnBloodProductValid);
			this._bloodProduct.ProductType.Valid += new System.EventHandler(OnBloodProductValid);
			this._bloodProduct.ProductType.Invalid += new System.EventHandler(OnBloodProductValid);
			this._bloodProduct.IsDirtyChanged += new System.EventHandler(OnBloodProductValid);
			this._bloodProduct.ProductType.IsDirtyChanged += new System.EventHandler(OnBloodProductValid);
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//Everytime a property of the variable is altered and thus the form
			//has been changed in one way or another.
			this._bloodProduct.IsDirtyChanged += new System.EventHandler(SetDirtyFlag);
			this._bloodProduct.ProductType.IsDirtyChanged += new System.EventHandler(SetDirtyFlag);
		}


		/// <summary>
		/// AttachProductShipperEvents
		/// </summary>
		private void AttachProductShipperEvents()
		{
			this._productShipper.Valid += new System.EventHandler(OnProductShipperValid);
			this._productShipper.Invalid += new System.EventHandler(OnProductShipperValid);
			this._productShipper.IsDirtyChanged += new System.EventHandler(OnProductShipperValid);
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//Everytime a property of the variable is altered and thus the form
			//has been changed in one way or another.
			this._productShipper.IsDirtyChanged += new System.EventHandler(SetDirtyFlag);
		}


		/// <summary>
		/// Set properties of user controls. IDE has a nasty habit of overriding values set at design time.
		/// </summary>
		private void SetComponentProperties()
		{
            this.LockController.LockFunction = LockFunctions.UC008MaintainBloodProduct;
			this.DialogResult = DialogResult.Cancel;

			vbecsLogo1.Title = this.Text.Replace("VBECS - ",String.Empty);
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC008.FrmBloodProductEdit());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.btnAdd.Text = "&Add";
			this.btnAdd.EnabledButton = false;

			//Get the divisionSupplier
			this._divisionSupplier = new BOL.Division(Common.LogonUser.LogonUserDivisionCode).LocalSupplierGuid;

			this.LoadFDAComboBox();

			//Set the tooltips for the controls
			this.toolTip1.SetToolTip(this.btnCancel , Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.toolTip1.SetToolTip(this.btnClear , Common.StrRes.Tooltips.UC008.btnClear().ResString);
			this.toolTip1.SetToolTip(this.btnHistory , Common.StrRes.Tooltips.UC008.btnHistory().ResString);
			this.toolTip1.SetToolTip(this.btnSearch , Common.StrRes.Tooltips.UC008.btnSearch().ResString);
			this.toolTip1.SetToolTip(this.cmbFDARegNum , Common.StrRes.Tooltips.UC008.cmbFDARegNum().ResString);
			this.toolTip1.SetToolTip(this.cmbHCPCSCode , Common.StrRes.Tooltips.UC008.cmbHCPCSCode().ResString);
			this.toolTip1.SetToolTip(this.cmbHCPCSText , Common.StrRes.Tooltips.UC008.cmbHCPCSText().ResString);
			this.toolTip1.SetToolTip(this.cmbSupplier , Common.StrRes.Tooltips.UC008.cmbSupplier().ResString);
			this.toolTip1.SetToolTip(this.lvSuppliers , Common.StrRes.Tooltips.UC008.lvSuppliers().ResString);
			this.toolTip1.SetToolTip(this.txtCode , Common.StrRes.Tooltips.UC008.txtCode().ResString);
			this.toolTip1.SetToolTip(this.txtDays , Common.StrRes.Tooltips.UC008.txtDays().ResString);
			this.toolTip1.SetToolTip(this.txtHours , Common.StrRes.Tooltips.UC008.txtHours().ResString);
			this.toolTip1.SetToolTip(this.txtName , Common.StrRes.Tooltips.UC008.txtName().ResString);
			this.toolTip1.SetToolTip(this.txtShortName , Common.StrRes.Tooltips.UC008.txtShortName().ResString);
			this.toolTip1.SetToolTip(this.txtType , Common.StrRes.Tooltips.UC008.txtType().ResString);
			this.toolTip1.SetToolTip(this.txtVolume , Common.StrRes.Tooltips.UC008.txtVolume().ResString);
			this.toolTip1.SetToolTip(this.updCost , Common.StrRes.Tooltips.UC008.updCost().ResString);
			this.toolTip1.SetToolTip(this.updReturnCredit , Common.StrRes.Tooltips.UC008.updReturnCredit().ResString);
		}


		/// <summary>
		/// Load cmbHCPCSCode and cmbHCPCSText comboboxes
		/// </summary>
		private void LoadHcpcsComboBox()
		{
			using (new WaitCursor())
			{
				_hcpcsCodes = BOL.BloodProduct.GetHcpcsCodes();

				//Populate the list of available HCPCS codes
				cmbHCPCSText.Items.Clear();
				cmbHCPCSCode.Items.Clear();
				foreach(DataRow dr in _hcpcsCodes.Rows)
				{
					if (dr[Common.VbecsTables.HcpcsCache.HcpcsCode].ToString() != String.Empty && dr[Common.VbecsTables.HcpcsCache.HcpcsName].ToString() != String.Empty)
					{
						cmbHCPCSCode.Items.Add(dr[Common.VbecsTables.HcpcsCache.HcpcsCode].ToString().Trim());
						cmbHCPCSText.Items.Add(dr[Common.VbecsTables.HcpcsCache.HcpcsName].ToString().Trim());
					}
				}
			}
		}

		/// <summary>
		/// Populates cmbFDARegNum and cmbSupplier comboboxes
		/// </summary>
		private void LoadFDAComboBox()
		{
			_facilities = BOL.ProductShipper.GetProductShippersByDivisionLookUpList();
			//Populate the list of available Local Suppliers
			cmbFDARegNum.Items.Clear();
			cmbSupplier.Items.Clear();
			foreach(DataRow dr in _facilities.Rows)
			{
				if (this._onlyAllowOneEdit)
				{
					if ((System.Guid)dr[Common.VbecsTables.LocalSupplier.LocalSupplierGuid] == this._targetSupplierGuid)
					{
						cmbFDARegNum.Items.Add(dr[Common.VbecsTables.LocalSupplier.FdaRegistrationNumber].ToString().Trim());
						cmbSupplier.Items.Add(dr[Common.VbecsTables.LocalSupplier.FacilityName].ToString());
						break;
					}
				}
				else
				{
					cmbFDARegNum.Items.Add(dr[Common.VbecsTables.LocalSupplier.FdaRegistrationNumber].ToString().Trim());
					cmbSupplier.Items.Add(dr[Common.VbecsTables.LocalSupplier.FacilityName].ToString());
				}				
			}
		}


		/// <summary>
		/// HasAuthorityToEditProduct
		/// </summary>
		/// <returns></returns>
		private bool HasAuthorityToEditProduct()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.ActivateEditBloodProductInformation );
		}


		/// <summary>
		/// HasAuthorityToEditShipppers
		/// </summary>
		/// <returns></returns>
		private bool HasAuthorityToEditShippers()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.ActivateEditShipperInformation );
		}


		/// <summary>
		/// Loads blood product properties based on given product code.
		/// </summary>
		/// <param name="productCode"></param>
		private bool GetBloodProduct(string productCode)
		{
			string ruleSet = Common.VbecsBrokenRules.FrmBloodProductEdit.RuleSets.Default;

			this.Working();

			//Clear - will unlock any locked records (in case "Search" was clicked mid-edit
			this.btnClear_Click(this, System.EventArgs.Empty);

			_multipleBloodProductCode = new MultipleBloodProductCode(ThisUser, this, productCode);
			
			switch(_multipleBloodProductCode.BloodProductsDataTable.Rows.Count)
			{
				case 0:		
					this.Stopped();
					return(true);
				default:
					this._bloodProduct = _multipleBloodProductCode.BloodProduct;
					if (this._bloodProduct.HcpcsCode.Trim().Length == 0)
						ruleSet = Common.VbecsBrokenRules.FrmBloodProductEdit.RuleSets.FirstEdit;

					if (!this.SetLocks(this._bloodProduct.BloodProductGuid))
					{
						this.Stopped();
						return(false);
					}

					this._bloodProduct.SetInitialBrokenRules(this.Name, ruleSet);
					this.AttachBloodProductEvents();
					this.SetControlState(2);
					break;
			}

			this.Ready();		
			this.SetBloodProductData(true);

			this.OnBloodProductValid(this, System.EventArgs.Empty);
			return(true);
		}

		/// <summary>
		/// Loads all product suppliers from data table into listview.
		/// </summary>
		private void LoadSuppliers()
		{
			this._isLoading = true;

			lvSuppliers.Items.Clear();

			//Just in case we've been sent in here to clean up
			if (this._bloodProduct != null)
			{
				foreach (BOL.ProductShipper _ps in this._bloodProduct.ProductShippers)
				{
					AddSupplier(_ps);
				}
			}

			this._isLoading = false;

			controls.VbecsFunction.SetColumnWidths(this.lvSuppliers);
		}


		/// <summary>
		/// Loads a product supplier into listview.
		/// </summary>
		/// <param name="productShipper"></param>
		private void AddSupplier(BOL.ProductShipper productShipper)
		{
			ListViewItem _shipper = new ListViewItem();

			_shipper.Checked = (productShipper.RecordStatusCode == RecordStatusCode.Active);
			_shipper.Tag = productShipper.LocalSupplierGuid;

			_shipper.SubItems.Add(productShipper.FDARegistrationNumber);
			_shipper.SubItems.Add(productShipper.FacilityName);
			_shipper.SubItems.Add(productShipper.ProductCost.ToString("C"));
			_shipper.SubItems.Add(productShipper.ReturnCreditPercentage.ToString());

			lvSuppliers.Items.Add(_shipper);
		}


		/// <summary>
		/// Initializes the values that can be updated for the product supplier.
		/// </summary>
		private void SetSupplierData(bool useObject)
		{
			this._isLoading = true;

			if (useObject)
			{
				this.cmbFDARegNum.SelectedIndex = this.cmbFDARegNum.Items.IndexOf(this._productShipper.FDARegistrationNumber.Trim());
				this.updCost.Value = this._productShipper.ProductCost;
				this.updReturnCredit.Value = this._productShipper.ReturnCreditPercentage;
				//
				this.ClearErrorProvider();
			}
			else
			{
				this.cmbFDARegNum.SelectedIndex = -1;
				this.updCost.Value = 0;
				this.updReturnCredit.Value = 100;
				//
				this.ClearErrorProvider();
			}
			
			//Disable the button since they can't do anything anyway
			this.btnAdd.SetToolTip(String.Empty);
			this.btnAdd.EnabledButton = false;

			this._isLoading = false;
		}


		#endregion

		#region Control Events
		
		/// <summary>
		/// txtCode_KeyUp Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtCode_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (!this._isLoading)
			{
				this.errError.SetIconAlignment(this.txtCode,ErrorIconAlignment.MiddleLeft);
				
				if (!this.txtCode.Barcode && this.txtCode.Text.Length >= 5)
				{
					try
					{
						if (this.GetBloodProduct(txtCode.Text))
							this.errError.SetVbecsError(this.txtCode,String.Empty);
					}
					catch(BOL.BusinessObjectException err)
					{
						this.errError.SetVbecsError(this.txtCode,err.Message);
					}
				}
			}
		}

		private void txtCode_Leave(object sender, System.EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					if (!this._isLoading)
					{
						this.errError.SetIconAlignment(this.txtCode,ErrorIconAlignment.MiddleLeft);

						if (this.txtCode.Barcode)
						{
							try
							{
								if (this.GetBloodProduct(txtCode.Text))
									this.errError.SetVbecsError(this.txtCode,String.Empty);
							}
							catch(BOL.BusinessObjectException err)
							{
								this.errError.SetVbecsError(this.txtCode,err.Message);
							}
						}
					}
				}
				finally
				{
					this.RecursionGuard = false;
				}
			}
		}


		/// <summary>
		/// Handles the updCost valuechanged and textchanged events
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CostChangedEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					if (this._bloodProduct == null) return;

					if (this.GetProductShipper(System.Guid.Empty))
					{
						try
						{
							this._productShipper.ProductCost = this.updCost.Value;
							this.errError.SetVbecsError(this.updCost, String.Empty);
						}
						catch(FormatException)
						{
							this._productShipper.ProductCost = decimal.MinusOne;
						}
					}
				}
				catch(BOL.BrokenRuleException err)
				{
					this.errError.SetVbecsError(this.updCost, err.Message);
				}
			}
		}

		/// <summary>
		/// Handles the updCost leave event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CostLeaveEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					if (this._bloodProduct == null) return;

					if (this.GetProductShipper(System.Guid.Empty))
					{
						try
						{
							this._productShipper.ProductCost = this.updCost.Value;
							this.errError.SetVbecsError(this.updCost, String.Empty);
						}
						catch(FormatException err)
						{
							this._productShipper.ProductCost = decimal.MinusOne;
							this.errError.SetVbecsError(this.updCost,err.Message);
						}

					}
				}
				catch(BOL.BrokenRuleException err)
				{
					this.errError.SetVbecsError(this.updCost, err.Message);
				}
			}
		}

		/// <summary>
		/// Handles the updReturnCredit TextChange, ValueChanged events
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReturnCreditChangedEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					if (this._bloodProduct == null) return;

					if (this.GetProductShipper(System.Guid.Empty))
					{
						try
						{
							this._productShipper.ReturnCreditPercentage = this.updReturnCredit.Value;
							this.errError.SetVbecsError(this.updReturnCredit, String.Empty);
						}
						catch(FormatException)
						{
							this._productShipper.ReturnCreditPercentage = decimal.MinusOne;
						}
					}
				}
				catch(BOL.BrokenRuleException err)
				{
					this.errError.SetVbecsError(this.updReturnCredit, err.Message);
				}
			}
		}

		/// <summary>
		/// Handles the updReturnCredit Leave events
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReturnCreditLeaveEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					if (this._bloodProduct == null) return;

					if (this.GetProductShipper(System.Guid.Empty))
					{
						try
						{
							this._productShipper.ReturnCreditPercentage = this.updReturnCredit.Value;
							this.errError.SetVbecsError(this.updReturnCredit, String.Empty);
						}
						catch(FormatException err)
						{
							this._productShipper.ReturnCreditPercentage = decimal.MinusOne;
							this.errError.SetVbecsError(this.updReturnCredit, err.Message);
						}
					}
				}
				catch(BOL.BrokenRuleException err)
				{
					this.errError.SetVbecsError(this.updReturnCredit, err.Message);
				}
			}
		}

		/// <summary>
		/// btnSearch Click event. Loads Blood Product search dialog. Any results are automatically entered into UI controls.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			DlgBloodProductSelect dlgProductSearch = new DlgBloodProductSelect();
            //LOCKING420 - refactor to use new locking-friendly showdialog
            dlgProductSearch.ShowDialogFromLockedParent(this, false);
			
			if (dlgProductSearch.DialogResult == DialogResult.OK)
			{
				this.GetBloodProduct(dlgProductSearch.BloodProduct.ProductCode);
			}

			dlgProductSearch.Dispose();
		}


		/// <summary>
		/// btnAdd Click event. Adds product supplier to datatable, or updates values if already in table.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			if (this.HasAuthorityToEditShippers())
			{
				this._bloodProduct.ProductShippers.Add(this._productShipper);
				this._productShipper = null;

				LoadSuppliers();
				this.SetSupplierData(false);

				//This updates the broken rules/ ok button
				this.OnBloodProductValid(this, System.EventArgs.Empty);
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges(
					"edit product supplier information"));
			}
		}


		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/16/2003</CreationDate>
		///
		/// <summary>
		/// Updates the Hcpcs code when a new code is choosen from the combo box.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbHcpcs_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this._bloodProduct == null) return;

				if (!this._isLoading)
				{
					if (cmbHCPCSCode.SelectedIndex < 0)
					{
						this._bloodProduct.HcpcsCode = String.Empty;
					}
					else
					{
						this._bloodProduct.HcpcsCode = _hcpcsCodes.Rows[this.cmbHCPCSCode.SelectedIndex][Common.VbecsTables.HcpcsCache.HcpcsCode].ToString();
					}
					this.errError.SetVbecsError(this.cmbHCPCSCode,String.Empty);
				}
			}
			catch(BOL.BrokenRuleException err)
			{
				this.errError.SetVbecsError(this.cmbHCPCSCode, err.Message);
			}
			//
			this.cmbHCPCSText.SelectedIndex = this.cmbHCPCSCode.SelectedIndex;
		}

		private void cmbHCPCSText_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.cmbHCPCSCode.SelectedIndex = this.cmbHCPCSText.SelectedIndex;
			this.cmbHcpcs_SelectedIndexChanged(sender,e);
		}


		/// <summary>
		/// lvSuppliers Click event. Loads supplier information of selected item in listview into edit controls
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSuppliers_Click(object sender, System.EventArgs e)
		{
			if (this._bloodProduct == null) return;

			if (lvSuppliers.SelectedItems.Count > 0)
			{
				//Reset the product supplier object so we get a new one
				this._productShipper = null;

				if (this.GetProductShipper((System.Guid)this.lvSuppliers.SelectedItems[0].Tag))
				{
					this.SetSupplierData(true);
					this.OnProductShipperValid(this,System.EventArgs.Empty);
				}
			}
		}


		/// <summary>
		/// lvSuppliers ColumnClick event. Sorts entries in list view by column clicked.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSuppliers_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSuppliers.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}


		/// <summary>
		/// btnOK Click event. Initiates database update/insert.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{

			if (this._bloodProduct.ProductShippers.ActiveShippersCount == 0)
			{
				DialogResult dlgResult1 = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC008.ContinueWithDeactivatedProduct());
				
				if (dlgResult1 == DialogResult.Yes)
				{
					//They dont want to make changes
				}
				else
				{
					//They want to add a shipper
					return;
				}
			}

			DialogResult _save = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("blood product"));

			if (_save == DialogResult.Yes)
			{
				try
				{
					this.Working();
					this._bloodProduct.Save(Common.UpdateFunction.UC008FrmBloodProductEdit);
					this.Ready();

					if (!this._onlyAllowOneEdit)
					{
						this.btnClear_Click(this, System.EventArgs.Empty);
						//Setting the dirty variable of the form to false
						//signaling that the data on the form has been saved.
						this.IsDirty=false;
					}
					else
					{
						this.OnProductShipperActivated(this._bloodProduct.IsProductShipperActive(this._targetSupplierGuid), System.EventArgs.Empty);
						//Setting the dirty variable of the form to false
						//signaling that the data on the form has been saved.
						this.IsDirty=false;
						this.DialogResult = DialogResult.OK;
						this.Close();
						return;
					}
				}
				catch(RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			}
		}


		/// <summary>
		/// btnCancel Click event. Closes form.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}


		/// <summary>
		/// lvSuppliers ItemCheck event. Updates active status of product supplier in data table if the check box is checked/unchecked.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSuppliers_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (!this._isLoading)
			{
				if (this._bloodProduct == null) return;

				System.Guid localSupplierGUID = (System.Guid)lvSuppliers.Items[e.Index].Tag;

				BOL.ProductShipper ps = this._bloodProduct.ProductShippers.GetElementByLocalSupplierGuid(localSupplierGUID);

				if (ps == null)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC008.ProductSupplierNotFound());
				}
				else
				{
					//If they checked the box, mark the shipper active
					if (e.NewValue == CheckState.Checked)
					{
						ps.RecordStatusCode = RecordStatusCode.Active;
					}
					else
					{
						if (BOL.BloodProduct.IsBloodProductOnActiveUnits(ps.BloodProductGuid, ps.LocalSupplierGuid))
						{
							//Displaying BR_8.11 message
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.BR811InactivateSupplier()); 
							e.NewValue = e.CurrentValue;
							return;
						}
						// ToDo: Add a check here to see if there are any active units in the DB
						// for this supplier and disallow if there are. -- look up moron
						ps.RecordStatusCode = RecordStatusCode.Inactive;
					}

					this._bloodProduct.ProductShippers.Add(ps);

					//This updates the broken rules/ ok button
					this.OnBloodProductValid(this, System.EventArgs.Empty);

				}
			}
		}



		/// <summary>
		/// btnClear_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this._bloodProduct = null;
			this._productShipper = null;

			//Wipes all the locks for this UC - since they just cleared anything they may 
			//have been working on, and don't have the data anymore
			this.UnlockAllRecords();

			this.ClearErrorProvider();

			this.SetBloodProductData(false);
			this.SetControlState(0);

			this.txtCode.Focus();

			this.btnOK.SetToolTip(string.Empty);
			this.btnAdd.SetToolTip(string.Empty);

			//Setting the dirty variable of the form to false
			this.IsDirty=false;
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/19/2003</CreationDate>
		///
		/// <summary>
		/// Enable the add button if a supplier is selected.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbSupplier_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!_isLoading)
			{
				if (this._bloodProduct == null) return;
				if (this.cmbSupplier.SelectedIndex > -1)
				{
					try
					{
						System.Guid facilityGuid = (System.Guid)this._facilities.Rows[this.cmbSupplier.SelectedIndex][Common.VbecsTables.LocalSupplier.LocalSupplierGuid];
						if (this.GetProductShipper(facilityGuid))
						{
							this._productShipper.LocalSupplierGuid = facilityGuid;
							this.errError.SetVbecsError(this.cmbSupplier, String.Empty);
						}
					}
					catch (BOL.BrokenRuleException err)
					{
						this.errError.SetVbecsError(this.cmbSupplier, err.Message);
					}
				}
				else
				{
					if (this.GetProductShipper(System.Guid.Empty))
					{
						this._productShipper.LocalSupplierGuid = System.Guid.Empty;
						this.errError.SetVbecsError(this.cmbSupplier, String.Empty);
					}
				}
			}
			//
			this.cmbFDARegNum.SelectedIndex = this.cmbSupplier.SelectedIndex;

			this.SetCostValues();	//CR 3024 - set GUI values to the object in case noobies like Ron set the cost before picking an existing supplier
		}		

		private void cmbFDARegNum_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.cmbSupplier.SelectedIndex = this.cmbFDARegNum.SelectedIndex;
			this.cmbSupplier_SelectedIndexChanged(sender,e);
		}		

		/// <summary>
		/// Load the HCPCS history for Blood Product
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnHistory_Click(object sender, System.EventArgs e)
		{
			
			DlgHcpcsHistory dlgHcpcsHistory = new DlgHcpcsHistory(this._bloodProduct.BloodProductGuid);

            //LOCKING420 - Refactored to use new Locking-friendly "ShowDialog" method
            dlgHcpcsHistory.ShowDialogFromLockedParent(this, false);
			dlgHcpcsHistory.Dispose();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmBloodProductEdit_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion

		private void lvSuppliers_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 Compliance
			this.SpeakListViewWithCheckBox(lvSuppliers);
		}

		#region Properties

		/// <summary>
		/// For UC to validate that the supplier was acivated
		/// </summary>
		public BOL.BloodProduct BloodProduct
		{
			get
			{
				return this._bloodProduct;
			}
		}


		#endregion
	}
}
